/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scope;

import java.util.Stack;
import java.util.regex.Pattern;

public class MatchContext {
    private static final Pattern spaces = Pattern.compile("\\s+");
    private String[] _steps;
    private int _currentIndex;
    private Stack<Integer> _savedPositions;

    MatchContext(String scope) {
        this._steps = scope != null ? spaces.split(scope) : new String[]{};
        this._currentIndex = this._steps.length - 1;
        this._savedPositions = new Stack();
    }

    public void advance() {
        ++this._currentIndex;
    }

    public void backup() {
        --this._currentIndex;
    }

    public boolean canAdvance() {
        return this._currentIndex < this._steps.length - 1;
    }

    public String getCurrentStep() {
        String result = null;
        if (this._currentIndex >= 0 && this._currentIndex < this._steps.length) {
            result = this._steps[this._currentIndex];
        }
        return result;
    }

    public int getLength() {
        return this._steps.length;
    }

    public void popCurrentStep() {
        this.popCurrentStep(true);
    }

    public void popCurrentStep(boolean restore) {
        if (this._savedPositions.size() > 0) {
            int value = this._savedPositions.pop();
            if (restore) {
                this._currentIndex = value;
            }
        }
    }

    public void pushCurrentStep() {
        this._savedPositions.push(this._currentIndex);
    }

    public String toString() {
        return this.getCurrentStep();
    }
}

